import time
import os
from playwright.sync_api import sync_playwright

def show_legal_notice():
    print("=" * 60)
    print("Webpage Screensaver Script (Python) by Anthro Entertainment LLC")
    print("-" * 60)
    print("LEGAL NOTICE: This tool can only be used for your own webpages")
    print("you own or have permission to save.")
    print("=" * 60)
    print("")

def scroll_to_bottom(page):
    """Scrolls down the page to trigger lazy-loading of images."""
    print("Scrolling to load all assets and images...")
    current_height = page.evaluate("document.body.scrollHeight")
    viewport_height = page.viewport_size["height"]
    
    for i in range(0, current_height, viewport_height):
        page.mouse.wheel(0, viewport_height)
        time.sleep(0.4) 
        
    page.evaluate("window.scrollTo(0, 0)")
    time.sleep(1) 

def take_screenshot():
    show_legal_notice()
    
    # 1. Get URL
    url = input("Enter the website URL: ").strip()
    if url.startswith("ttps://"):
        url = "h" + url
    elif not url.startswith("http"):
        url = "https://" + url

    # 2. Get Filename
    filename = input("Enter output filename (e.g., MyPortfolio): ").strip()
    if not filename:
        filename = "website_capture"

    # 3. Get Format
    print("\nChoose format:")
    print("1. JPG (Smaller file size, good for business plans)")
    print("2. PNG (Highest quality, best for itch.io assets)")
    choice = input("Select 1 or 2: ").strip()

    file_extension = ".jpg" if choice == "1" else ".png"
    img_type = "jpeg" if choice == "1" else "png"
    
    # Add extension if the user didn't type it
    if not filename.lower().endswith(file_extension):
        filename += file_extension

    print(f"\nAttempting to capture: {url}")
    
    try:
        with sync_playwright() as p:
            browser = p.chromium.launch(headless=True)
            context = browser.new_context(
                viewport={'width': 1280, 'height': 800},
                user_agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"
            )
            page = context.new_page()
            
            # Load page
            page.goto(url, wait_until="networkidle", timeout=90000)
            
            # Scroll to fix white images
            scroll_to_bottom(page)
            
            # Save the file
            if img_type == "jpeg":
                page.screenshot(path=filename, type="jpeg", quality=95, full_page=True)
            else:
                page.screenshot(path=filename, type="png", full_page=True)
            
            print("-" * 60)
            print(f"SUCCESS: Saved to {os.path.abspath(filename)}")
            print("-" * 60)
            
            browser.close()
    except Exception as e:
        print(f"\nERROR: Could not capture the page. \nDetails: {e}")

if __name__ == "__main__":
    take_screenshot()